/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.TickerDisplayModel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageLineRTF;
import DE.siemens.ad.udf.UDFParameterItem;
import java.awt.Point;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageManager {
    private WiringDiagram fWiringDiagram;
    private HashMap tickerModels;

    private MessageManager() {
    }

    public MessageManager(WiringDiagram wd) {
        this.setWiringDiagram(wd);
    }

    public synchronized int getFreeMessageNumber() {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getWiringDiagram().getHardware().getMaxResource(12)];
        for (i = 0; i < msgBlocks.length; ++i) {
            int number = ((MessageParameter)msgBlocks[i].getParameter()).getMsgNumber();
            if (used[number]) {
                System.err.println("error, duplicated Message number" + number);
            }
            used[number] = true;
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            return i;
        }
        System.err.println("Error MessageManager.getFreeMessageNumber(): Zu wenig Meldetextnummern verf\u00fcgbar!");
        return -1;
    }

    public Vector getFreePriorities() {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        Vector<Integer> result = new Vector<Integer>();
        for (i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    public synchronized int getFreeMessageTextID() {
        MessageBlock[] msgBlocks;
        int maxCount = 50;
        boolean[] used = new boolean[maxCount];
        boolean needDoReassign = false;
        Vector<MessageBlock> needReassignBlock = new Vector<MessageBlock>(0);
        for (MessageBlock block : msgBlocks = this.getMessageBlocks()) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)block.getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                int textID = msgText.getTextID();
                if (textID == -1 || used[textID]) {
                    MessageParameter.MessageText firstText;
                    if (j == 1 && (firstText = ((MessageParameter)block.getParameter()).getMessageRTF(0)) != null) {
                        used[firstText.getTextID()] = false;
                    }
                    System.err.println("duplicated text id" + textID + ", try to recover");
                    needDoReassign = true;
                    break;
                }
                used[textID] = true;
            }
            if (!needDoReassign) continue;
            needReassignBlock.add(block);
            needDoReassign = false;
        }
        if (needReassignBlock.size() > 0) {
            this.doReassignTextID(needReassignBlock, used);
        }
        for (int i = 0; i < maxCount; ++i) {
            if (used[i]) continue;
            return i;
        }
        return -1;
    }

    public synchronized int getFreeMessageTextIDExcept(int reservedID) {
        MessageBlock[] msgBlocks;
        int maxCount = 50;
        boolean[] used = new boolean[maxCount];
        boolean needDoReassign = false;
        Vector<MessageBlock> needReassignBlock = new Vector<MessageBlock>(0);
        for (MessageBlock block : msgBlocks = this.getMessageBlocks()) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)block.getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                int textID = msgText.getTextID();
                if (textID == -1 || used[textID]) {
                    MessageParameter.MessageText firstText;
                    if (j == 1 && (firstText = ((MessageParameter)block.getParameter()).getMessageRTF(0)) != null) {
                        used[firstText.getTextID()] = false;
                    }
                    System.err.println("duplicated text id" + textID + ", try to recover");
                    needDoReassign = true;
                    break;
                }
                used[textID] = true;
            }
            if (!needDoReassign) continue;
            needReassignBlock.add(block);
            needDoReassign = false;
        }
        if (needReassignBlock.size() > 0) {
            this.doReassignTextID(needReassignBlock, used);
        }
        for (int i = 0; i < maxCount; ++i) {
            if (used[i] || i == reservedID) continue;
            return i;
        }
        return -1;
    }

    private void doReassignTextID(Vector<MessageBlock> needReassignBlock, boolean[] used) {
        for (MessageBlock block : needReassignBlock) {
            block1: for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)block.getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                for (int k = 0; k < 50; ++k) {
                    if (used[k]) continue;
                    msgText.setTextID(k);
                    used[k] = true;
                    continue block1;
                }
            }
        }
    }

    public int getUsedTextIDCount() {
        int ret = 0;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getFreeID(int type, Block block, Vector currentUsedIDs) {
        int ret;
        int i;
        Vector<Integer> usedID = new Vector<Integer>();
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (i = 0; i < msgBlocks.length; ++i) {
            if (msgBlocks[i] == block) continue;
            for (int j = 0; j < 2; ++j) {
                MessageParameter.MessageText msgText = ((MessageParameter)msgBlocks[i].getParameter()).getMessageRTF(j);
                if (msgText == null) continue;
                MessageLineRTF[] lines = msgText.getMessageLineRTF();
                for (int k = 0; k < lines.length; ++k) {
                    Object[] IDs = this.getIdArray(lines[k], type);
                    for (int p = 0; p < IDs.length; ++p) {
                        usedID.add((Integer)IDs[p]);
                    }
                }
            }
        }
        for (i = 0; i < currentUsedIDs.size(); ++i) {
            usedID.add((Integer)currentUsedIDs.elementAt(i));
        }
        int maxCount = this.getMaxIDResource(type);
        for (ret = 0; ret < maxCount && usedID.contains(ret); ++ret) {
        }
        if (ret == maxCount) {
            ret = -1;
        }
        return ret;
    }

    public int getMaxIDResource(int type) {
        if (type == MessageLineRTF.BAR_ID) {
            return 32;
        }
        if (type == MessageLineRTF.STATUS_NAME_IO_ID) {
            return this.fWiringDiagram.getHardware().getIntProperty("RTFMaxIOStatusItemTotal");
        }
        return 0;
    }

    private Object[] getIdArray(MessageLineRTF line, int type) {
        if (type == MessageLineRTF.BAR_ID) {
            return line.getBarGraphMap().keySet().toArray();
        }
        if (type == MessageLineRTF.STATUS_NAME_IO_ID) {
            return line.getIONameMap().keySet().toArray();
        }
        return null;
    }

    private int getNrOfPriority() {
        return this.fWiringDiagram.getHardware().getIntProperty("msgPrioCount");
    }

    public synchronized Integer getFreePriority() {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        for (i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i]) continue;
            return new Integer(i);
        }
        System.out.println("Error MessageManager.getFreePriority(): Zu wenig Priorit\u00e4ten verf\u00fcgbar!");
        return new Integer(-1);
    }

    public MessageBlock[] getMessageBlocks() {
        Enumeration blocks = this.getWiringDiagram().getBlocks().elements();
        Vector<Block> msgBlocks = new Vector<Block>();
        while (blocks.hasMoreElements()) {
            Block block = (Block)blocks.nextElement();
            if (!(block instanceof MessageBlock)) continue;
            msgBlocks.add(block);
        }
        return msgBlocks.toArray(new MessageBlock[msgBlocks.size()]);
    }

    public MessageBlock[] getMessageBlocksToOutput() {
        Vector allOpenBlocks = this.getWiringDiagram().getOpenBlocks();
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        Vector<MessageBlock> result = new Vector<MessageBlock>(5);
        for (int i = 0; i < msgBlocks.length; ++i) {
            if (allOpenBlocks.contains(msgBlocks[i])) continue;
            result.add(msgBlocks[i]);
        }
        return result.toArray(new MessageBlock[result.size()]);
    }

    public WiringDiagram getWiringDiagram() {
        return this.fWiringDiagram;
    }

    public boolean isPriorityUsed(Integer testPrio) {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getNrOfPriority()];
        for (int i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getPriority().intValue()] = true;
        }
        return used[testPrio];
    }

    public boolean isMsgNumberValid(Integer msgNumber) {
        int maxMessageCount = this.getWiringDiagram().getHardware().getMaxResource(12);
        if (msgNumber >= maxMessageCount || msgNumber <= -1) {
            return false;
        }
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[maxMessageCount];
        for (int i = 0; i < msgBlocks.length; ++i) {
            used[((MessageParameter)msgBlocks[i].getParameter()).getMsgNumber()] = true;
        }
        return !used[msgNumber];
    }

    private void setWiringDiagram(WiringDiagram newWiringDiagram) {
        this.fWiringDiagram = newWiringDiagram;
    }

    public String toString() {
        return super.toString();
    }

    public void verifyMessageLineParameterReferences() {
        MessageParameter messageParameter = null;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (int i = 0; i < messageBlocks.length; ++i) {
            boolean messageLineCleared = false;
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            messageLineCleared = this.messageLinesCleared(messageParameter);
            if (!messageLineCleared) continue;
            messageParameter.fireParameterSetEvent();
        }
    }

    private boolean messageLinesCleared(MessageParameter param) {
        boolean messageLineCleared = false;
        if (!this.isRTFMessage()) {
            MessageLine[] messageLines = param.getMessage();
            for (int i = 0; i < messageLines.length; ++i) {
                if (!messageLines[i].messageLineCleared()) continue;
                messageLineCleared = true;
            }
        } else {
            for (int index = 0; index < 2; ++index) {
                if (param.getMessageRTF(index) == null) continue;
                MessageLineRTF[] messageLines = param.getMessageRTF(index).getMessageLineRTF();
                for (int i = 0; i < messageLines.length; ++i) {
                    if (!messageLines[i].messageLineCleared()) continue;
                    messageLineCleared = true;
                }
            }
        }
        return messageLineCleared;
    }

    public boolean isRTFMessage() {
        boolean ret = this.fWiringDiagram.getMessageGlobalInfo().isFUseNewFeature();
        if (ret && !this.fWiringDiagram.getHardware().supports("supportAsiaLanguage")) {
            System.err.println("Conliction in RTF new feature setting.");
        }
        return ret;
    }

    public void transferToRTF(int newCharSet) {
        int i;
        MessageParameter messageParameter = null;
        boolean ret = true;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (i = 0; i < messageBlocks.length; ++i) {
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            if (ret &= messageParameter.syncPlainToRTFStyle(newCharSet)) continue;
            System.err.println(messageParameter.getBlock().getNumberString());
        }
        Log.println("" + i + " " + Language.getString("dialog.parameter.message.transferToRTF", " Message blocks transferred to RTF style."));
    }

    public void transferToPlain() {
        MessageParameter messageParameter = null;
        MessageBlock[] messageBlocks = this.getMessageBlocks();
        for (int i = 0; i < messageBlocks.length; ++i) {
            messageParameter = (MessageParameter)messageBlocks[i].getParameter();
            messageParameter.syncRTFToPlainStyle();
        }
        Log.println("" + messageBlocks.length + " " + Language.getString("dialog.parameter.message.transferToNonRTF", " Message blocks transferred to plain style."));
    }

    public boolean transferContentsToCharset(int charSetID, int newCharSet) {
        if (charSetID < 0 || charSetID >= 2 || MessageGlobalInfo.getCharSetName(newCharSet) == null) {
            System.err.println("MessageManager.transferToNewCharset(), invalid parameter.");
            return false;
        }
        MessageParameter messageParameter = null;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            messageParameter = (MessageParameter)msgBlocks[i].getParameter();
            if (messageParameter.getMessageRTF(charSetID) == null) continue;
            messageParameter.transferContentsToCharset(charSetID, newCharSet);
        }
        this.fWiringDiagram.getMessageGlobalInfo().setSelectedCharSets(newCharSet, charSetID);
        return true;
    }

    public int getSpecialMarkerValue(int number) {
        Block block = this.getMarkerWithLeftConnected(number);
        if (block != null) {
            return block.getBinaryValue() ? 1 : 0;
        }
        return -1;
    }

    private Block getMarkerWithLeftConnected(int blockNumber) {
        Block block = this.fWiringDiagram.getBlockByNumberExt(10, blockNumber);
        return block;
    }

    public void setFreeMessageNumber() {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        boolean[] used = new boolean[this.getWiringDiagram().getHardware().getMaxResource(12)];
        for (int i = 0; i < msgBlocks.length; ++i) {
            ((MessageParameter)msgBlocks[i].getParameter()).setMsgNumber(i);
            used[i] = true;
        }
    }

    public void clearMessageNumber() {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            ((MessageParameter)msgBlocks[i].getParameter()).setMsgNumber(-1);
        }
    }

    public void clearRTFModels() {
        if (this.tickerModels != null) {
            MessageBlock[] msgBlocks = this.getMessageBlocks();
            for (int i = 0; i < msgBlocks.length; ++i) {
                MessageParameter msgParam = (MessageParameter)msgBlocks[i].getParameter();
                for (int j = 0; j < msgParam.getMessageRTFs().length; ++j) {
                    if (msgParam.getMessageRTF(j) == null) continue;
                    TickerDisplayModel model = this.getDisplayModel(msgParam, j);
                    model.removeAsParameterSetListener(msgParam);
                }
            }
            this.tickerModels.clear();
            this.tickerModels = null;
        }
    }

    public TickerDisplayModel getDisplayModel(MessageParameter msgParam, int charset) {
        TickerDisplayModel ret;
        if (this.tickerModels == null) {
            this.tickerModels = new HashMap();
        }
        if ((ret = (TickerDisplayModel)this.tickerModels.get(this.getTickerKey(msgParam, charset))) == null) {
            ret = new TickerDisplayModel(msgParam, charset);
            this.tickerModels.put(this.getTickerKey(msgParam, charset), ret);
            ret.addAsParameterSetListener(msgParam);
        }
        return ret;
    }

    private String getTickerKey(MessageParameter msgParam, int charset) {
        return msgParam.getMsgNumber() + "_" + charset;
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        for (int i = 0; i < msgBlocks.length; ++i) {
            MessageParameter param = (MessageParameter)msgBlocks[i].getParameter();
            for (int charsetID = 0; charsetID < 2; ++charsetID) {
                if (param.getMessageRTF(charsetID) == null) continue;
                MessageLineRTF[] lines = param.getMessageRTF(charsetID).getMessageLineRTF();
                for (int y = 0; y < lines.length; ++y) {
                    int x = 0;
                    while (x < lines[y].getLineWidth()) {
                        DisplayElement disp = lines[y].getDisplayElement(x);
                        if (disp instanceof ScaleTimeDisplayElement) {
                            if (!hw.supports("supportScaleTime")) {
                                errorList.add(new ErrorInfo(param, "error.convert.messageBlock.ScaleTimeNotSupported", hw));
                                return false;
                            }
                        } else if (disp instanceof UDFParameterItem && !hw.supports("UDF")) {
                            errorList.add(new ErrorInfo(param, "error.convert.messageBlock.udfParameterIsnotSupported", hw));
                            return false;
                        }
                        if (disp != null) {
                            x += disp.getWidth();
                            continue;
                        }
                        ++x;
                    }
                }
            }
        }
        return this.isIOStatusNameAvailable(hw, errorList);
    }

    private boolean isIOStatusNameAvailable(Hardware hw, List errorList) {
        int i;
        MessageBlock[] msgBlocks = this.getMessageBlocks();
        int totalCount = 0;
        int countInParam = 0;
        int[] supportedType = (int[])hw.getProperty("TypeInStatusName");
        if (supportedType == null) {
            // empty if block
        }
        Vector<Integer> typeVec = new Vector<Integer>();
        for (i = 0; i < supportedType.length; ++i) {
            typeVec.add(supportedType[i]);
        }
        for (i = 0; i < msgBlocks.length; ++i) {
            MessageParameter param = (MessageParameter)msgBlocks[i].getParameter();
            for (int charsetID = 0; charsetID < 2; ++charsetID) {
                if (param.getMessageRTF(charsetID) == null) continue;
                MessageLineRTF[] lines = param.getMessageRTF(charsetID).getMessageLineRTF();
                countInParam = 0;
                for (int y = 0; y < lines.length; ++y) {
                    if ((countInParam += lines[y].getIONameMap().keySet().size()) > hw.getIntProperty("RTFMaxIOStatusItem")) {
                        errorList.add(new ErrorInfo(param, "error.convert.messageBlock.tooManyIONameInText", hw));
                        return false;
                    }
                    int x = 0;
                    while (x < lines[y].getLineWidth()) {
                        DisplayElement disp = lines[y].getDisplayElement(x);
                        if (disp instanceof IONameDisplayElement && !typeVec.contains(((IONameDisplayElement)disp).getBlock().getNumberType())) {
                            errorList.add(new ErrorInfo(param, "error.convert.messageBlock.unsupportedIOName", hw));
                            return false;
                        }
                        if (disp != null) {
                            x += disp.getWidth();
                            continue;
                        }
                        ++x;
                    }
                }
                if ((totalCount += countInParam) <= hw.getIntProperty("RTFMaxIOStatusItemTotal")) continue;
                errorList.add(new ErrorInfo(hw, "error.convert.messageBlock.tooManyIOName", hw));
                return false;
            }
        }
        return true;
    }

    public static void fillMessageLinesFromDisplayModel(MessageParameter msgParam, DisplayModel model) {
        MessageLine[] messageLine = new MessageLine[4];
        int displayHeight = model.getDisplayDimension().height;
        int displayWidth = model.getDisplayDimension().width;
        for (int zeile = 0; zeile < displayHeight; ++zeile) {
            messageLine[zeile] = new MessageLine();
            StringBuffer lineText = new StringBuffer();
            int spalte = 0;
            while (spalte < displayWidth) {
                DisplayElement displayElement = model.getElementAt(new Point(spalte, zeile));
                if (displayElement instanceof ParameterItem) {
                    ParameterItem parameterItem = (ParameterItem)displayElement;
                    messageLine[zeile].setBlockParameter(parameterItem.getParameter());
                    messageLine[zeile].setParameterItemIdentifier(parameterItem.getIdentifier());
                    messageLine[zeile].setParameterPosition(spalte);
                    spalte += displayElement.getWidth();
                }
                if (displayElement != null && displayElement.getClass() == DefaultDisplayElement.class) {
                    DefaultDisplayElement defaultDisplayElement = (DefaultDisplayElement)displayElement;
                    String text = defaultDisplayElement.getUserObject().toString();
                    if (text != null && text.length() > 0) {
                        lineText.append(text.charAt(0));
                    } else {
                        lineText.append(' ');
                    }
                    spalte += displayElement.getWidth();
                }
                if (displayElement != null && displayElement.getClass() == SpecialCharacterDisplayElement.class) {
                    SpecialCharacterDisplayElement specialCharacterDisplayElement = (SpecialCharacterDisplayElement)displayElement;
                    char code = (char)specialCharacterDisplayElement.getCharCode();
                    lineText.append(code);
                    spalte += displayElement.getWidth();
                }
                if (displayElement == null) {
                    lineText.append(' ');
                    ++spalte;
                }
                messageLine[zeile].setText(lineText.toString());
            }
        }
        for (int i = 0; i < msgParam.getMessage().length; ++i) {
            msgParam.getMessage()[i].copyFrom(messageLine[i], true);
        }
    }

    public static void fillMessageLineRTFsFromDisplayModel(MessageParameter.MessageText messageText, DisplayModel displayModel) {
        MessageLineRTF[] messageLine = messageText.getMessageLineRTF();
        int displayHeight = displayModel.getDisplayDimension().height;
        int displayWidth = displayModel.getDisplayDimension().width;
        for (int y = 0; y < displayHeight; ++y) {
            int x = 0;
            while (x < displayWidth) {
                DisplayElement displayElement = displayModel.getElementAt(new Point(x, y));
                if (displayModel.getElementBounds((Point)new Point((int)x, (int)y)).y == y) {
                    messageLine[y].setDisplayElement(displayElement, x);
                } else {
                    displayElement = null;
                    messageLine[y].setDisplayElement(null, x);
                }
                if (displayElement != null) {
                    x += displayElement.getWidth();
                    continue;
                }
                ++x;
            }
        }
    }
}

